<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateProfileRequest;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class UserController extends Controller
{
    /**
     * @return void
     */
    public static function routes(): void
    {
        Route::group(['prefix' => 'user'], function () {
            Route::get('', [self::class, 'profile']);
            Route::put('', [self::class, 'updateProfile']);
        });
    }

    public function profile()
    {
        return success(UserResource::make(Auth::user()));
    }

    /**
     * @param UpdateProfileRequest $request
     * @return object
     */
    public function updateProfile(UpdateProfileRequest $request): object
    {
        Auth::user()->update($request->validated());

        return success(UserResource::make(Auth::user()), status: Response::HTTP_ACCEPTED);
    }
}
