<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Http\Requests\OtpRequest;
use App\Models\User;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class AuthController extends Controller
{
    /**
     * @return void
     */
    public static function routes(): void
    {
        Route::group(['prefix' => 'auth'], function () {
            Route::post('otp', [self::class, 'otp'])->middleware('throttle:otp');
            Route::post('login', [self::class, 'login']);
        });
    }

    /**
     * @param OtpRequest $request
     * @return mixed
     * @throws GuzzleException
     */
    public function otp(OtpRequest $request): object
    {
        $user = User::where(User::MOBILE, $request->input(User::MOBILE))->first();

        if (!$user)
            $user = User::create($request->validated());

        if (!config('app.debug'))
            $random = rand(100000, 999999);

        $user->setMeta('otp', $random ?? 123456);

        if (!config('app.debug'))
            sendOtp("0" . $user->mobile, $random);

        return success([], 'info.authenticate.otp');
    }

    public function login(LoginRequest $request)
    {
        $user = User::where(User::MOBILE, $request->input(User::MOBILE))->firstOrFail();

        if ($user->getMeta('otp')->value != $request->input('code'))
            return error('info.authenticate.bad_request', null, Response::HTTP_BAD_REQUEST);

        $user->setMeta('otp', '-');
        $user->token = $user->createToken('login')->plainTextToken;

        return success($user->makeHidden('meta'));
    }
}
