<?php


use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;
use Rp76\Guzzle\ResponseData;
use Src\FarazSms\FarazSms;

function getCityById(?int $id): ?array
{
    return collect(__('cities'))->where('id', $id)->first();
}

function getProvinceById(?int $id): ?array
{
    return collect(__('provinces'))->where('id', $id)->first();
}

function success($data, string $message = "info.received_successfully", int $status = 200, array $headers = [])
{
    return Response::success($data, __($message), $status, $headers);
}

function error(string $message, ?array $errors, int $status)
{
    return Response::error(__($message), $errors, $status);
}

/**
 * @param UploadedFile|null $file
 * @param string $path
 * @return string
 */
function uploadFile(?UploadedFile $file, string $path = "upload/"): string
{
    if (!$file)
        return '';

    if ($file->getMimeType() === 'application/zip')
        return uploadZipFile($file,$path);

    $imageName = uniqid() . "." . $file->getClientOriginalExtension();
    $file->move(public_path($path), $imageName);

    return $path . $imageName;
}

/**
 * @param string $phone
 * @param int $token
 * @return ResponseData
 * @throws GuzzleException
 */
function sendOtp(string $phone, int $token): ResponseData
{
    $sms = new FarazSms();

    return $sms->sendPattern(FarazSms::VERIFICATION_CODE, $phone, [
        'verification-code' => $token,
    ]);
}

/**
 * @param UploadedFile|null $file
 * @param string $path
 * @return string
 */
function uploadZipFile(?UploadedFile $file, string $path = "upload/"): string
{
    $folderName = uniqid();
    File::makeDirectory(public_path($path.$folderName), 0755, true, true);

    $zip = new ZipArchive();
    $zip->open($file);

    $zip->extractTo(public_path($path.$folderName));
    $zip->close();

    $scene=array_filter(File::files(public_path($path.$folderName)), function (SplFileInfo $item) {
        return in_array($item->getExtension(), ['gltf', 'fbx', 'obg', 'glb']);
    });

    $sceneName=end($scene)->getFilename();

    return $path .$folderName.'/'. $sceneName;
}
