<?php

namespace App\Http\Requests;

use App\Models\File;
use App\Models\Scene;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class FileStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            File::USER_ID => ['nullable'],
            File::SCENE_ID => ['required', 'numeric', Rule::exists('scenes', 'id')->where(Scene::USER_ID, Auth::id())],
            'file' => ['required', 'file'],
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            File::USER_ID => Auth::id(),
        ]);
    }

    public function validated($key = null, $default = null)
    {
        $validated = parent::validated($key, $default);

        return array_merge($validated, [
            File::PATH => uploadFile($this->file('file')),
        ]);
    }
}
