<?php

namespace App\Http\Requests;

use App\Models\Project;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ProjectStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            Project::USER_ID => ['nullable'],
            Project::TITLE => ['required', 'max:256', 'string']
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            Project::USER_ID => Auth::id(),
        ]);
    }
}
