<?php

namespace App\Http\Requests;

use App\Models\Project;
use App\Models\Scene;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class SceneStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            Scene::TITLE => ['required', 'max:64'],
            Scene::PROJECT_ID => ['required', Rule::exists('projects', 'id')->where(Project::USER_ID, Auth::id()), 'numeric'],
        ];
    }
}
