<?php

namespace App\Http\Requests;

use App\Models\Project;
use App\Models\Scene;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

/**
 * @property mixed $scene
 */
class SceneUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            Scene::TITLE => ['nullable', 'max:64'],
            Scene::SLUG => ['required', 'max:128', Rule::unique('scenes')->ignore($this->scene)],
            Scene::PROJECT_ID => ['nullable', Rule::exists('projects', 'id')->where(Project::USER_ID, Auth::id()), 'numeric'],
            Scene::DATA => ['required', 'array'],
        ];
    }
}
