<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed $id
 * @property mixed $user_id
 * @property mixed $scene_id
 * @property mixed $path
 * @property mixed $created_at
 * @property mixed $updated_at
 */
class FileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'scene_id' => $this->scene_id,
            'path' => asset($this->path),
            'user' => UserResource::make($this->whenLoaded('user')),
            'scene' => SceneResource::make($this->whenLoaded('scene')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
