<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed $id
 * @property mixed $user_id
 * @property mixed $project_id
 * @property mixed $slug
 * @property mixed $data
 * @property mixed $created_at
 * @property mixed $updated_at
 * @property mixed $title
 */
class SceneResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'project_id' => $this->project_id,
            'title' => $this->title,
            'slug' => $this->slug,
            'data' => $this->whenAppended('data',function (){
                return $this->data;
            }),
            'user' => UserResource::make($this->whenLoaded('user')),
            'project' => ProjectResource::make($this->whenLoaded('project')),
            'files' => FileResourceCollection::make($this->whenLoaded('files')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
