<?php

namespace App\Http\Resources;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed id
 * @property mixed type
 * @property mixed mobile
 * @property mixed firstname
 * @property mixed surname
 * @property mixed email_verified_at
 * @property mixed $deleted_at
 * @property mixed $created_at
 * @property mixed $updated_at
 */
class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'is_admin' => $this->type === User::TYPE_ADMIN,
            'mobile' => $this->mobile,
            'firstname' => $this->firstname,
            'surname' => $this->surname,
            'is_verify' => (bool)$this->email_verified_at,
            'is_deleted' => (bool)$this->deleted_at,
            'projects' => ProjectResourceCollection::make($this->whenLoaded('projects')),
            'scenes' => SceneResourceCollection::make($this->whenLoaded('scenes')),
            'files' => FileResourceCollection::make($this->whenLoaded('files')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
