<?php

namespace App\Models;

use App\Traits\PipeAble;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed $user_id
 * @property string $path
 * @method static pipe(string[] $array)
 * @method static create(mixed $validated)
 */
class File extends Model
{
    use HasFactory, PipeAble, SoftDeletes;

    const
        ID = "id",
        USER_ID = 'user_id',
        SCENE_ID = 'scene_id',
        PATH = 'path',
        DELETED_AT = "deleted_at",
        CREATED_AT = "created_at",
        UPDATED_AT = "updated_at";

    protected $fillable = [
        self::USER_ID,
        self::SCENE_ID,
        self::PATH,
    ];

    public function getMorphClass(): string
    {
        return class_basename(self::class);
    }

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return BelongsTo
     */
    public function scene(): BelongsTo
    {
        return $this->belongsTo(Scene::class);
    }
}
