<?php

namespace App\Models;

use App\Traits\PipeAble;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @method static page()
 * @method static create(mixed $validated)
 * @method static pipe(string[] $array)
 * @property int $user_id
 */
class Project extends Model
{
    use HasFactory, PipeAble, SoftDeletes;

    const
        ID = "id",
        USER_ID = 'user_id',
        TITLE = 'title',
        DELETED_AT = "deleted_at",
        CREATED_AT = "created_at",
        UPDATED_AT = "updated_at";

    protected $fillable = [
        self::USER_ID,
        self::TITLE,
    ];

    public function getMorphClass(): string
    {
        return class_basename(self::class);
    }

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return HasMany
     */
    public function scenes(): HasMany
    {
        return $this->hasMany(Scene::class);
    }
}
