<?php

namespace App\Models;

use App\Traits\PipeAble;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property int $id
 * @property object $data
 * @property int $user_id
 * @method static pipe(string[] $array)
 * @method static create(array $array)
 */
class Scene extends Model
{
    use HasFactory, PipeAble,SoftDeletes;

    const
        ID = "id",
        USER_ID = 'user_id',
        PROJECT_ID = 'project_id',
        TITLE = 'title',
        SLUG = 'slug',
        DATA = 'data',
        DELETED_AT = "deleted_at",
        CREATED_AT = "created_at",
        UPDATED_AT = "updated_at";

    protected $fillable = [
        self::USER_ID,
        self::PROJECT_ID,
        self::TITLE,
        self::SLUG,
        self::DATA,
    ];

    protected $casts=[
        self::DATA=>'object'
    ];

    public function getMorphClass(): string
    {
        return class_basename(self::class);
    }

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return BelongsTo
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    /**
     * @return HasMany
     */
    public function files(): HasMany
    {
        return $this->hasMany(File::class);
    }
}
