<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Traits\Metable;
use App\Traits\PipeAble;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

/**
 * @method static page()
 * @method static pipe(string[] $array)
 * @method static create(mixed $array_filter)
 * @method static where(string $MOBILE, int $mobile)
 * @property int $id
 */
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, Metable, PipeAble,SoftDeletes;

    const ID = 'id',
        TYPE = 'type',
        MOBILE = 'mobile',
        FIRSTNAME = 'firstname',
        SURNAME = 'surname',
        EMAIL_VERIFIED_AT = 'email_verified_at',
        PASSWORD = 'password',
        REMEMBER_TOKEN = 'remember_token',
        DELETED_AT = 'deleted_at',
        CREATED_AT = 'created_at',
        UPDATED_AT = 'updated_at';

    const TYPE_ADMIN = 'admin',
        TYPE_USER = 'user';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        self::TYPE,
        self::MOBILE,
        self::FIRSTNAME,
        self::SURNAME,
        self::EMAIL_VERIFIED_AT,
        self::PASSWORD,
        self::REMEMBER_TOKEN,
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        self::PASSWORD,
        self::REMEMBER_TOKEN,
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function getMorphClass(): string
    {
        return class_basename(self::class);
    }

    /**
     * @return HasMany
     */
    public function projects(): HasMany
    {
        return $this->hasMany(Project::class);
    }

    /**
     * @return HasMany
     */
    public function scenes(): HasMany
    {
        return $this->hasMany(Scene::class);
    }

    /**
     * @return HasMany
     */
    public function files(): HasMany
    {
        return $this->hasMany(File::class);
    }
}
