<?php

namespace App\Providers;

use App\Http\Classes\Response as RpResponse;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        if (!env("APP_DEBUG")) {
            URL::forceScheme('https');
        } else {
            URL::forceScheme("http");
        }

        Response::macro('success', function ($data, string $message, int $status, array $headers = []) {
            return new RpResponse([
                'status' => true,
                'message' => $message,
                'info' => key_exists('resource', (array)$data) ? $data->response()->getData() : $data
            ], $status, array_merge(
                [
                    'version' => config('app.version'),
                    'app_name' => config('app.name')
                ],
                $headers
            ));
        });

        Response::macro('error', function ($message, ?array $errors, $status, array $headers = []) {
            return new RpResponse([
                'status' => false,
                'message' => $message,
                'errors' => $errors
            ], $status, array_merge(
                [
                    'version' => config('app.version'),
                    'app_name' => config('app.name')
                ],
                $headers
            ));
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Model::preventLazyLoading();
        JsonResource::withoutWrapping();
    }
}
