<?php

namespace Src\FarazSms;

use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Psr7\Request;
use Rp76\Guzzle\Client;
use Rp76\Guzzle\ResponseData;

class FarazSms
{
    public const VERIFICATION_CODE = 'rrc2bdz9g9xpzls';

    protected Client $client;
    protected string $number = '981000002365';
    protected string $username;
    protected string $password;

    public function __construct()
    {
        $this->client = new Client([
            'base_uri' => 'http://ippanel.com:8080/',
            'timeout' => 15,
            'verify' => false
        ]);

        $this->username = config('app.sms_username');
        $this->password = config('app.sms_password');
    }

    /**
     * @param string $pattern
     * @param string $receiver
     * @param array|null $data
     * @return ResponseData
     * @throws GuzzleException
     */
    public function sendPattern(string $pattern, string $receiver, ?array $data = null): ResponseData
    {
        $newData = [];

        $request = new Request('GET', '');

        if ($data)
            collect($data)->each(function ($value, $key) use (&$index, &$newData) {
                $index++;

                $newData["p$index"] = $key;
                $newData["v$index"] = $value;

                return $newData;
            });

        return $this->client->easySend($request, [
            'query' => array_merge(
                [
                    'pid' => $pattern,
                    'fnum' => $this->number,
                    'tnum' => $receiver,
                    'apikey' => config('app.sms_api_key'),
                ],
                $newData
            )]);
    }

    /**
     * @param string $receiver
     * @param string $message
     * @return ResponseData
     * @throws GuzzleException
     */
    public function sendRegular(string $receiver, string $message): ResponseData
    {
        $request = new Request('GET', 'http://ippanel.com/class/sms/webservice/send_url.php');

        return $this->client->easySend($request, [
            'query' => [
                'uname' => $this->username,
                'pass' => $this->password,
                'from' => $this->number,
                'to' => $receiver,
                'msg' => $message,
            ]
        ]);

    }
}
